// Copyright 2014 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file is autogenerated by:
//     mojo/public/tools/bindings/mojom_bindings_generator.py
// For:
//     content/common/presentation/presentation_service.mojom
//

package org.chromium.mojom.presentation;

public interface PresentationService extends org.chromium.mojo.bindings.Interface {

    public interface Proxy extends PresentationService, org.chromium.mojo.bindings.Interface.Proxy {
    }

    Manager<PresentationService, PresentationService.Proxy> MANAGER = PresentationService_Internal.MANAGER;

    void setDefaultPresentationUrl(String url);

    void setClient(PresentationServiceClient client);

    void listenForScreenAvailability(String url);

    void stopListeningForScreenAvailability(String url);

    void listenForDefaultSessionStart(ListenForDefaultSessionStartResponse callback);
    interface ListenForDefaultSessionStartResponse extends org.chromium.mojo.bindings.Callbacks.Callback1<PresentationSessionInfo> { }

    void startSession(String presentationUrl, StartSessionResponse callback);
    interface StartSessionResponse extends org.chromium.mojo.bindings.Callbacks.Callback2<PresentationSessionInfo, PresentationError> { }

    void joinSession(String presentationUrl, String presentationId, JoinSessionResponse callback);
    interface JoinSessionResponse extends org.chromium.mojo.bindings.Callbacks.Callback2<PresentationSessionInfo, PresentationError> { }

    void sendSessionMessage(PresentationSessionInfo sessionInfo, SessionMessage messageRequest, SendSessionMessageResponse callback);
    interface SendSessionMessageResponse extends org.chromium.mojo.bindings.Callbacks.Callback1<Boolean> { }

    void closeSession(String presentationUrl, String presentationId);

    void listenForSessionStateChange();

    void listenForSessionMessages(PresentationSessionInfo sessionInfo);
}

